/* Important rules:
 * - Addr.mode without an operand (IMPLIED) must be the last for any mnemonic.
 * - DPAGE addr. modes should come last too, but before IMPLIED.
 */
  "adc",  {XIND   ,YIND   }, {0x99,0x00},
  "adc",  {ACCU   ,IMMED  }, {0x88,0x00},
  "adc",  {ACCU   ,XIND   }, {0x86,0x00},
  "adc",  {ACCU   ,DPINDY }, {0x97,0x00},
  "adc",  {ACCU   ,DPINDX }, {0x87,0x00},
  "adc",  {ACCU   ,ABS    }, {0x85,0x84},
  "adc",  {ACCU   ,ABSX   }, {0x95,0x94},
  "adc",  {ACCU   ,ABSY   }, {0x96,0x00},
  "adc",  {DPAGE  ,DPAGE  }, {0x89,0x89},
  "adc",  {DPAGE  ,IMMED  }, {0x98,0x98},
  "addw", {YACCU  ,DPAGE  }, {0x7a,0x7a},

  "and",  {XIND   ,YIND   }, {0x39,0x00},
  "and",  {ACCU   ,IMMED  }, {0x28,0x00},
  "and",  {ACCU   ,XIND   }, {0x26,0x00},
  "and",  {ACCU   ,DPINDY }, {0x37,0x00},
  "and",  {ACCU   ,DPINDX }, {0x27,0x00},
  "and",  {ACCU   ,ABS    }, {0x25,0x24},
  "and",  {ACCU   ,ABSX   }, {0x35,0x34},
  "and",  {ACCU   ,ABSY   }, {0x36,0x00},
  "and",  {DPAGE  ,DPAGE  }, {0x29,0x29},
  "and",  {DPAGE  ,IMMED  }, {0x38,0x38},

  "and1", {CFLAG  ,ABSBITN}, {0x6a,0x00},
  "and1", {CFLAG  ,ABSBIT }, {0x4a,0x00},

  "asl",  {ACCU   ,       }, {0x1c,0x00},
  "asl",  {ABS    ,       }, {0x0c,0x0b},
  "asl",  {DPAGEX ,       }, {0x1b,0x1b},

  "bbc",  {DPBIT  ,BREL   }, {0x13,0x00},
  "bbs",  {DPBIT  ,BREL   }, {0x03,0x00},
  "bcc",  {BREL   ,       }, {0x90,0x00},
  "bcs",  {BREL   ,       }, {0xb0,0x00},
  "beq",  {BREL   ,       }, {0xf0,0x00},
  "bne",  {BREL   ,       }, {0xd0,0x00},
  "bpl",  {BREL   ,       }, {0x10,0x00},
  "bmi",  {BREL   ,       }, {0x30,0x00},
  "bvc",  {BREL   ,       }, {0x50,0x00},
  "bvs",  {BREL   ,       }, {0x70,0x00},
  "bra",  {BREL   ,       }, {0x2f,0x00},

  "brk",  {IMPLIED,       }, {0x0f,0x00},
  "call", {ABS    ,       }, {0x3f,0x00},
  "cbne", {DPAGEX ,BREL   }, {0xde,0xde},
  "cbne", {DPAGE  ,BREL   }, {0x2e,0x2e},

  "clr1", {DPBIT  ,       }, {0x12,0x00},
  "clrc", {IMPLIED,       }, {0x60,0x00},
  "clrp", {IMPLIED,       }, {0x20,0x00},
  "clrv", {IMPLIED,       }, {0xe0,0x00},

  "cmp",  {XIND   ,YIND   }, {0x79,0x00},
  "cmp",  {ACCU   ,IMMED  }, {0x68,0x00},
  "cmp",  {ACCU   ,XIND   }, {0x66,0x00},
  "cmp",  {ACCU   ,DPINDY }, {0x77,0x00},
  "cmp",  {ACCU   ,DPINDX }, {0x67,0x00},
  "cmp",  {ACCU   ,ABS    }, {0x65,0x64},
  "cmp",  {ACCU   ,ABSX   }, {0x75,0x74},
  "cmp",  {ACCU   ,ABSY   }, {0x76,0x00},
  "cmp",  {XREG   ,IMMED  }, {0xc8,0x00},
  "cmp",  {XREG   ,ABS    }, {0x1e,0x3e},
  "cmp",  {YREG   ,IMMED  }, {0xad,0x00},
  "cmp",  {YREG   ,ABS    }, {0x5e,0x7e},
  "cmp",  {DPAGE  ,DPAGE  }, {0x69,0x69},
  "cmp",  {DPAGE  ,IMMED  }, {0x78,0x78},
  "cmpw", {YACCU  ,DPAGE  }, {0x5a,0x5a},

  "daa",  {ACCU   ,       }, {0xdf,0x00},
  "das",  {ACCU   ,       }, {0xbe,0x00},

  "dbnz", {YREG   ,BREL   }, {0xfe,0x00},
  "dbnz", {DPAGE  ,BREL   }, {0x6e,0x6e},

  "dec",  {ACCU   ,       }, {0x9c,0x00},
  "dec",  {XREG   ,       }, {0x1d,0x00},
  "dec",  {YREG   ,       }, {0xdc,0x00},
  "dec",  {ABS    ,       }, {0x8c,0x8b},
  "dec",  {DPAGEX ,       }, {0x9b,0x9b},
  "decw", {DPAGE  ,       }, {0x1a,0x1a},

  "di",   {IMPLIED,       }, {0xc0,0x00},
  "div",  {YACCU  ,XREG   }, {0x9e,0x00},
  "ei",   {IMPLIED,       }, {0xa0,0x00},

  "eor",  {XIND   ,YIND   }, {0x59,0x00},
  "eor",  {ACCU   ,IMMED  }, {0x48,0x00},
  "eor",  {ACCU   ,XIND   }, {0x46,0x00},
  "eor",  {ACCU   ,DPINDY }, {0x57,0x00},
  "eor",  {ACCU   ,DPINDX }, {0x47,0x00},
  "eor",  {ACCU   ,ABS    }, {0x45,0x44},
  "eor",  {ACCU   ,ABSX   }, {0x55,0x54},
  "eor",  {ACCU   ,ABSY   }, {0x56,0x00},
  "eor",  {DPAGE  ,DPAGE  }, {0x49,0x49},
  "eor",  {DPAGE  ,IMMED  }, {0x58,0x58},

  "eor1", {CFLAG  ,ABSBIT }, {0x8a,0x00},

  "inc",  {ACCU   ,       }, {0xbc,0x00},
  "inc",  {XREG   ,       }, {0x3d,0x00},
  "inc",  {YREG   ,       }, {0xfc,0x00},
  "inc",  {ABS    ,       }, {0xac,0xab},
  "inc",  {DPAGEX ,       }, {0xbb,0xbb},
  "incw", {DPAGE  ,       }, {0x3a,0x3a},

  "jmp",  {JMPINDX,       }, {0x1f,0x00},
  "jmp",  {ABS    ,       }, {0x5f,0x00},

  "lsr",  {ACCU   ,       }, {0x5c,0x00},
  "lsr",  {ABS    ,       }, {0x4c,0x4b},
  "lsr",  {DPAGEX ,       }, {0x5b,0x5b},

  "mov",  {XINDINC,ACCU   }, {0xaf,0x00},
  "mov",  {XIND   ,ACCU   }, {0xc6,0x00},
  "mov",  {DPINDY ,ACCU   }, {0xd7,0x00},
  "mov",  {DPINDX ,ACCU   }, {0xc7,0x00},
  "mov",  {ACCU   ,IMMED  }, {0xe8,0x00},
  "mov",  {ACCU   ,XIND   }, {0xe6,0x00},
  "mov",  {ACCU   ,XINDINC}, {0xbf,0x00},
  "mov",  {ACCU   ,DPINDY }, {0xf7,0x00},
  "mov",  {ACCU   ,DPINDX }, {0xe7,0x00},
  "mov",  {ACCU   ,XREG   }, {0x7d,0x00},
  "mov",  {ACCU   ,YREG   }, {0xdd,0x00},
  "mov",  {ACCU   ,ABS    }, {0xe5,0xe4},
  "mov",  {ACCU   ,ABSX   }, {0xf5,0xf4},
  "mov",  {ACCU   ,ABSY   }, {0xf6,0x00},
  "mov",  {SPREG  ,XREG   }, {0xbd,0x00},
  "mov",  {XREG   ,IMMED  }, {0xcd,0x00},
  "mov",  {XREG   ,ACCU   }, {0x5d,0x00},
  "mov",  {XREG   ,SPREG  }, {0x9d,0x00},
  "mov",  {XREG   ,ABS    }, {0xe9,0xf8},
  "mov",  {XREG   ,DPAGEY }, {0xf9,0xf9},
  "mov",  {YREG   ,IMMED  }, {0x8d,0x00},
  "mov",  {YREG   ,ACCU   }, {0xfd,0x00},
  "mov",  {YREG   ,ABS    }, {0xec,0xeb},
  "mov",  {YREG   ,DPAGEX }, {0xfb,0xfb},
  "mov",  {ABSX   ,ACCU   }, {0xd5,0xd4},
  "mov",  {ABSY   ,ACCU   }, {0xd6,0x00},
  "mov",  {ABS    ,ACCU   }, {0xc5,0xc4},
  "mov",  {ABS    ,XREG   }, {0xc9,0xd8},
  "mov",  {ABS    ,YREG   }, {0xcc,0xcb},
  "mov",  {DPAGEX ,YREG   }, {0xdb,0xdb},
  "mov",  {DPAGEY ,XREG   }, {0xd9,0xd9},
  "mov",  {DPAGE  ,DPAGE  }, {0xfa,0xfa},
  "mov",  {DPAGE  ,IMMED  }, {0x8f,0x8f},

  "mov1", {CFLAG  ,ABSBIT }, {0xaa,0x00},
  "mov1", {ABSBIT ,CFLAG  }, {0xca,0x00},

  "movw", {YACCU  ,DPAGE  }, {0xba,0xba},
  "movw", {DPAGE  ,YACCU  }, {0xda,0xda},

  "mul",  {YACCU  ,       }, {0xcf,0x00},
  "nop",  {IMPLIED,       }, {0x00,0x00},

  "not1", {ABSBIT ,       }, {0xea,0x00},
  "notc", {IMPLIED,       }, {0xed,0x00},

  "or",   {XIND   ,YIND   }, {0x19,0x00},
  "or",   {ACCU   ,IMMED  }, {0x08,0x00},
  "or",   {ACCU   ,XIND   }, {0x06,0x00},
  "or",   {ACCU   ,DPINDY }, {0x17,0x00},
  "or",   {ACCU   ,DPINDX }, {0x07,0x00},
  "or",   {ACCU   ,ABS    }, {0x05,0x04},
  "or",   {ACCU   ,ABSX   }, {0x15,0x14},
  "or",   {ACCU   ,ABSY   }, {0x16,0x00},
  "or",   {DPAGE  ,DPAGE  }, {0x09,0x09},
  "or",   {DPAGE  ,IMMED  }, {0x18,0x18},

  "or1",  {CFLAG  ,ABSBITN}, {0x2a,0x00},
  "or1",  {CFLAG  ,ABSBIT }, {0x0a,0x00},

  "pcall",{PCALL  ,       }, {0x4f,0x00},

  "pop",  {ACCU   ,       }, {0xae,0x00},
  "pop",  {XREG   ,       }, {0xce,0x00},
  "pop",  {YREG   ,       }, {0xee,0x00},
  "pop",  {PSW    ,       }, {0x8e,0x00},

  "push", {ACCU   ,       }, {0x2d,0x00},
  "push", {XREG   ,       }, {0x4d,0x00},
  "push", {YREG   ,       }, {0x6d,0x00},
  "push", {PSW    ,       }, {0x0d,0x00},

  "ret",  {IMPLIED,       }, {0x6f,0x00},
  "reti", {IMPLIED,       }, {0x7f,0x00},

  "rol",  {ACCU   ,       }, {0x3c,0x00},
  "rol",  {ABS    ,       }, {0x2c,0x2b},
  "rol",  {DPAGEX ,       }, {0x3b,0x3b},

  "ror",  {ACCU   ,       }, {0x7c,0x00},
  "ror",  {ABS    ,       }, {0x6c,0x6b},
  "ror",  {DPAGEX ,       }, {0x7b,0x7b},

  "sbc",  {XIND   ,YIND   }, {0xb9,0x00},
  "sbc",  {ACCU   ,IMMED  }, {0xa8,0x00},
  "sbc",  {ACCU   ,XIND   }, {0xa6,0x00},
  "sbc",  {ACCU   ,DPINDY }, {0xb7,0x00},
  "sbc",  {ACCU   ,DPINDX }, {0xa7,0x00},
  "sbc",  {ACCU   ,ABS    }, {0xa5,0xa4},
  "sbc",  {ACCU   ,ABSX   }, {0xb5,0xb4},
  "sbc",  {ACCU   ,ABSY   }, {0xb6,0x00},
  "sbc",  {DPAGE  ,DPAGE  }, {0xa9,0xa9},
  "sbc",  {DPAGE  ,IMMED  }, {0xb8,0xb8},
  "subw", {YACCU  ,DPAGE  }, {0x9a,0x9a},

  "set1", {DPBIT  ,       }, {0x02,0x00},
  "setc", {IMPLIED,       }, {0x80,0x00},
  "setp", {IMPLIED,       }, {0x40,0x00},

  "sleep",{IMPLIED,       }, {0xef,0x00},
  "stop", {IMPLIED,       }, {0xff,0x00},

  "tcall",{TCALL  ,       }, {0x01,0x00},

  "tclr1",{ABS    ,       }, {0x4e,0x00},
  "tset1",{ABS    ,       }, {0x0e,0x00},

  "xcn",  {ACCU   ,       }, {0x9f,0x00}
